<?php
/**
 * Test PDF files and paths
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

$DOCS_DIR = dirname(__FILE__) . '/docs';

echo "<h1>PDF Test</h1>";

echo "<h2>Directory Information</h2>";
echo "DOCS_DIR: " . htmlspecialchars($DOCS_DIR) . "<br>";
echo "Directory exists: " . (is_dir($DOCS_DIR) ? 'Yes' : 'No') . "<br>";
echo "Directory readable: " . (is_readable($DOCS_DIR) ? 'Yes' : 'No') . "<br>";

echo "<h2>PDF Files Found</h2>";

function findPDFs($dir, $prefix = '') {
    if (!is_dir($dir)) return;
    
    $items = scandir($dir);
    foreach ($items as $item) {
        if ($item === '.' || $item === '..') continue;
        
        $itemPath = $dir . '/' . $item;
        $relativePath = $prefix . $item;
        
        if (is_dir($itemPath)) {
            echo "<strong>" . htmlspecialchars($relativePath) . "/</strong><br>";
            findPDFs($itemPath, $relativePath . '/');
        } else {
            $fileInfo = pathinfo($item);
            if (isset($fileInfo['extension']) && strtolower($fileInfo['extension']) === 'pdf') {
                echo "📄 " . htmlspecialchars($relativePath);
                echo " (Size: " . filesize($itemPath) . " bytes)";
                echo " <a href='?pdf=" . urlencode($relativePath) . "' target='_blank'>View</a>";
                echo " <a href='?pdf=" . urlencode($relativePath) . "&debug=1' target='_blank'>Debug</a>";
                echo "<br>";
            } else {
                echo "📄 " . htmlspecialchars($relativePath) . " (not PDF)<br>";
            }
        }
    }
}

findPDFs($DOCS_DIR, 'docs/');

// Test specific PDF serving
if (isset($_GET['pdf'])) {
    $requestedPath = $_GET['pdf'];
    $pdfPath = $DOCS_DIR . '/' . str_replace('docs/', '', $requestedPath);
    
    echo "<h2>PDF Serving Test</h2>";
    echo "Requested: " . htmlspecialchars($requestedPath) . "<br>";
    echo "Constructed path: " . htmlspecialchars($pdfPath) . "<br>";
    echo "File exists: " . (file_exists($pdfPath) ? 'Yes' : 'No') . "<br>";
    echo "File readable: " . (is_readable($pdfPath) ? 'Yes' : 'No') . "<br>";
    echo "Real path: " . htmlspecialchars(realpath($pdfPath)) . "<br>";
    
    if (isset($_GET['debug'])) {
        echo "<h3>Debug Mode - Not serving file</h3>";
    } else if (file_exists($pdfPath) && is_readable($pdfPath)) {
        echo "<h3>Serving PDF...</h3>";
        header('Content-Type: application/pdf');
        header('Content-Length: ' . filesize($pdfPath));
        header('Content-Disposition: inline; filename="' . basename($pdfPath) . '"');
        readfile($pdfPath);
        exit;
    } else {
        echo "<h3>Cannot serve file - does not exist or not readable</h3>";
    }
}
?>
